/* Author:		Feng, Xia		Last modified: Nov 4, 1998

This program is to change Internet Explorer's FAVORATE to 
	a html file which can be used as Netscape's BOOKMARK.
*/

#include <direct.h>
#include <afx.h>
#include <fstream.h>
#include <iostream.h>
#include "URL2HTML.h"


void help(); // a simple help to indicate the usage of this program

void main(int argc, char *argv[])
{
	CFavorite *favorite; // the class object which is going to do all the process actually 

	if (argc == 2)
	{
		if (argv[1][0] == '/' && argv[1][1] == '?')
		{
			help();
			return;
		}
	}

	// create the object according the parameters user given.
	if (argc == 1)
	{
		favorite = new CFavorite();
	}
	else if (argc == 2)
	{
		favorite = new CFavorite(argv[1]);
	}
	else if (argc == 3)
	{
		favorite = new CFavorite(argv[1], argv[2]);
	}

	// if there are any errors occured during the object creating, then
	// this program should exit;
	
	if (favorite->IsError())
		return;

	// add file head to object html file
	favorite->AddFileHead();

	// add directory head to object html file
	favorite->AddDirHead();	

	// add directory content to object html file
	favorite->AddDirContent(favorite->GetFavoriteDir());

	// add directory tail to object html file
	favorite->AddDirTail();
}

CFavorite::CFavorite(char * cpBookmarkDir, char * cpFavoriteDir)
{
	strBookmarkDir = cpBookmarkDir;
	strFavoriteDir = cpFavoriteDir;
	flag_error = false;

	f.open(cpBookmarkDir, ios::in|ios::out|ios::trunc);
	if (!f.is_open())
	{
		cout << "failure to open file: " << cpBookmarkDir << endl;
		flag_error = true;
	}
}

CFavorite::~CFavorite()
{
	f.close();
}

// change and add directory's content to object file,
// strDir is the name of father directory
// strFile is the name of object directory, exclude which father directory
void CFavorite::AddDirContent(CString strDir, CString strFile)
{
	if (strFile.IsEmpty())
		strFile = strDir;
	else
		strFile = strDir + "\\" + strFile;

	// change current directory to object directory
	if (_chdir( (LPCTSTR)strFile))
	{
		cout << "failure to change directory: " << strFile << endl;
		return;
	}

	CFileFind finder;    
	BOOL bWorking = finder.FindFile("*.*");
	while (bWorking)
    {        
		bWorking = finder.FindNextFile();
		CString fname = finder.GetFileName();

		if (finder.IsDirectory())
		{
			if (!finder.IsDots()) // ignore directory . and ..
				if (!IsDirEmpty(strFile, fname)) // ignore channel
					AddDir(strFile, fname);
		}
		else
		{
			try
			{
				CString dex = fname.Right(4);
				if (dex.CompareNoCase(".URL") == 0) // ignore files which are not URL file
					AddURL(fname);
			}
			catch(CMemoryException e)
			{
			}
		}
	}

	// change current directory to father directory
	if (_chdir( (LPCTSTR)strDir))
	{
		cout << "failure to change directory: " << strDir << endl;
		return;
	}
}

void CFavorite::AddDirContent(CString strDir)
{
	AddDirContent(strDir, "");
}

void CFavorite::AddFileHead()
{
	f << "<!DOCTYPE NETSCAPE-Bookmark-file-1>" << endl
	<< "<!-- This is an file generated by Xia Feng's URL2HTML." << endl
	<< "It will be read and overwritten." << endl
	<< "Do Not Edit! -->" << endl
	<< "<meta name=\"GENERATOR\" content=\"URL2HTML by Xia Feng\">" << endl
	<< "<TITLE>Feng Xia's Bookmarks</TITLE>" << endl
	<< "<H1>Feng Xia's Bookmarks</H1>" << endl
	<< endl;
}


void CFavorite::AddDirHead()
{
	f << "<DL><p>" << endl;
}


void CFavorite::AddDirTail()
{
	f << "</DL><p>" << endl;
}

void CFavorite::AddDir(CString dirName, CString fname)
{

	f << "<DT><H3 ADD_DATE=\"884567655\">" << fname << "</H3>" << endl;

	AddDirHead();
	AddDirContent(dirName, fname);
	AddDirTail();
}

void CFavorite::AddURL(CString name)
{
	ifstream furl(name);
	char url[1001];

	if (furl.is_open())
	{
		furl.getline(url, 1000);
		furl.getline(url, 1000);
		furl.close();
	}

	name = name.Left(name.GetLength() - 4);
	f << "<DT><A HREF=\"" <<url+4 << "\"" 
		<< "ADD_DATE=\"882645605\" LAST_VISIT=\"886620180\" LAST_MODIFIED=\"882645585\">" 
		<< name << " </A>" << endl;
}


/* check if a directory is "empty". 
	If a directory only include channels ,files which types 
		are not URL file and subdirectorys which are "empty" themself,
	then this directory is "empty"
 */
bool CFavorite::IsDirEmpty(CString strDir, CString strFile)
{
	strFile = strDir + "\\" + strFile;

	if (_chdir( (LPCTSTR)strFile))
	{
		cout << "failure to change directory: " << strDir << endl;
		return true;
	}

	CFileFind finder;    
	BOOL bWorking = finder.FindFile("*.*");
	bool empty = true;

	while (bWorking && empty)
    {        
		bWorking = finder.FindNextFile();
		CString fname = finder.GetFileName();

		if (!finder.IsDirectory())
		{
			try
			{
				CString dex = fname.Right(4);
				if (dex.CompareNoCase(".URL") == 0)
					empty = false;
			}
			catch(CMemoryException e)
			{
			}
		}
	}

	bWorking = finder.FindFile("*.*");
	while (bWorking && empty)
    {        
		bWorking = finder.FindNextFile();
		CString fname = finder.GetFileName();

		if (finder.IsDirectory())
		{
			if (!finder.IsDots())
				empty = IsDirEmpty(strFile, fname);
		}
	}

	if (_chdir( (LPCTSTR)strDir))
	{
		cout << "failure to change directory: " << strDir << endl;
		return true;
	}
	return empty;
}

// a simple help to indicate the usage of this program
void help()
{
			cout << "Husage: " << endl
				<< "	1.FAVORITE2 " << endl
				<< "		IE FAVORITE DIRECTORY : c:\\windows\\favorites" <<endl
				<< "		NETSCAPE BOOKMARK FILE: bookmark.html" << endl << endl
				<< "	2.FAVORITE2 c:\\mybookmark.html" << endl
				<< "		IE FAVORITE DIRECTORY : c:\\windows\\favorites" <<endl
				<< "		NETSCAPE BOOKMARK FILE: c:\\mybookmark.html" << endl << endl
				<< "	3.FAVORITE2 mybookmark.html c:\\win\\favorites" << endl
				<< "		IE FAVORITE DIRECTORY : c:\\win\\favorites" <<endl
				<< "		NETSCAPE BOOKMARK FILE: mybookmark.html" << endl;
}